<?php
/**
 * Ppn Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Ppn extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Ppn_model');
	}
	
	public function index() {
		$data['content_title'] = 'PPN';

		$this->twiggy_display('adm/ppn/index', $data);

	}

	public function get_data() {
		$data = [];
		$get_data = $this->Ppn_model->get_data()->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {

				$is_active = ($get_row->is_active == '1' ? '<i class="fas fa-check text-success"></i>' : '<i class="fas fa-times text-danger"></i>');

				$data[] = array(
					'no'        => $no,
					'id'        => $get_row->id,
					'amount'    => to_decimal($get_row->amount),
					'is_active' => $is_active,
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id='new') {
		$title    = "Tambah";
		$get_data = array();

		if($id != 'new') {
			$title    = "Edit";
			$where = array('id' => $id);
			$get_data = $this->Ppn_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/ppn/edit', $data);
	}

	public function save() {
		// post
		$id     = $this->input->post('id');
		$amount = $this->input->post('amount');
		$active = $this->input->post('active');
		$action = $this->input->post('action');

		$data_save = array(
			'amount'    => $amount,
			'is_active' => $active,
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save_1  = $this->Ppn_model->save($data_save);
			if($save_1){
				$next_id = $this->db->insert_id();
			}
		} else {
			$convert    = convert_button($action, $id);
			$where_this = array('id' => $id);
			$save_1     = $this->Ppn_model->update($where_this, $data_save);
			if($save_1){
				$next_id = $id;
			}
		}

		if($active == 1){
			$where  = array('id !=' => $next_id);
			$status = array(
				'is_active' => '0',
			);
			$save   = $this->Ppn_model->update($where, $status);
		}else{
			$save   = true;
		}

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Ppn_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id() {
		$name  = $this->input->post('id');
		$where = array('amount' => $name);

		$check = $this->Ppn_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

}

?>
